// Copyright (C) 2012 Kornel Kisielewicz
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_ROOT_HH
#define NV_ROOT_HH

#include <nv/common.hh>
#include <nv/object.hh>
#include <nv/string.hh>
#include <list>

namespace nv
{
	/**
	 * Implements the root of a object tree-like structure.
	 */
	class root : public object
	{
	public:
		virtual void child_added( object* ) {}
		virtual void child_removed( object* ) {}
		type_database* get_type_database() const { return m_type_database; }
		lua::state*    get_lua_state()     const { return m_lua_state; }
		uid_store*     get_uid_store()     const { return m_uid_store; }
	protected:
		type_database* m_type_database;
		lua::state*    m_lua_state;
		uid_store*     m_uid_store; 
	};

} // namespace nv

#endif // NV_ROOT_HH
