// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh

#ifndef NV_TEXTURE_FONT_HH
#define NV_TEXTURE_FONT_HH

#include <nv/common.hh>
#include <string>
#include <nv/gfx/texture_atlas.hh>
#include <glm/glm.hpp>
#include <unordered_map>

namespace nv
{
	struct texture_glyph
	{
		uint16 charcode;
		glm::ivec2 size;
		glm::ivec2 offset;
		glm::vec2 advance;
		glm::vec2 tl;
		glm::vec2 br;
		std::unordered_map< uint16, float > kerning;

		texture_glyph();
		float get_kerning( const uint16 charcode );
	};

	class texture_font
	{
		public:
			texture_font( texture_atlas* atlas, const char * filename, float size );
			const texture_glyph* get_glyph( uint16 charcode ) const;
			bool load_glyphs( const std::string& codes );
			~texture_font();
		private:
			void generate_kerning();
		private:
			std::unordered_map< uint16, texture_glyph > m_glyphs;
			texture_atlas* m_atlas;
			std::string m_filename;
			float m_size;
			float m_height;
			float m_linegap;
			float m_ascender;
			float m_descender;
			bool m_hinting;
			bool m_filtering;
			uint8 m_lcd_weights[5];
			void* m_rlibrary;
			void* m_rface;
	};
}

#endif // NV_TEXTURE_FONT_HH

