// Copyright (C) 2012-2013 ChaosForge / Kornel Kisielewicz
// http://chaosforge.org/
//
// This file is part of NV Libraries.
// For conditions of distribution and use, see copyright notice in nv.hh
#ifndef NV_LUA_GLM_HH
#define NV_LUA_GLM_HH

#include <new>
#include <nv/common.hh>
#include <glm/glm.hpp>
#include <nv/lib/lua.hh>

void nlua_register_glm( lua_State* L );

template< typename T > inline const char* nlua_metatable_name() { static_assert(sizeof(T) == 0, "Type not implemented!"); return NULL; }

template< typename T >
bool nlua_is_vec( lua_State* L, int index )
{
	return luaL_testudata( L, index, nlua_metatable_name<T>() ) != 0;
}

template< typename T >
T nlua_to_vec( lua_State* L, int index )
{
	return *(T*)luaL_checkudata( L, index, nlua_metatable_name<T>() );
}

template< typename T >
T* nlua_to_pvec( lua_State* L, int index )
{
	return (T*)luaL_checkudata( L, index, nlua_metatable_name<T>() );
}

template< typename T >
void nlua_push_vec( lua_State* L, const T& v )
{
	new (lua_newuserdata(L, sizeof(T))) T(v);
	luaL_setmetatable( L, nlua_metatable_name<T>() );
}

template<> inline const char* nlua_metatable_name< glm::ivec2 >() { return "ivec2"; }
template<> inline const char* nlua_metatable_name< glm::ivec3 >() { return "ivec3"; }
template<> inline const char* nlua_metatable_name< glm::ivec4 >() { return "ivec4"; }
template<> inline const char* nlua_metatable_name< glm::vec2  >() { return "vec2"; }
template<> inline const char* nlua_metatable_name< glm::vec3  >() { return "vec3"; }
template<> inline const char* nlua_metatable_name< glm::vec4  >() { return "vec4"; }

#endif // NV_LUA_GLM_HH
